
<?php $__env->startSection('title', 'Performance Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
  <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Performance Dashboard</h1>
  <small class="tw-text-gray-600">Last 24 hours</small>
  <div class="pull-right">
    <a href="<?php echo e(url()->current(), false); ?>" class="tw-dw-btn tw-dw-btn-sm tw-dw-btn-outline tw-dw-btn-primary">Refresh</a>
  </div>
</section>

<section class="content">
  <?php if(session('status')): ?>
    <?php $st = session('status'); ?>
    <div class="alert alert-<?php echo e(!empty($st['success']) ? 'success' : 'danger', false); ?>"><?php echo e($st['msg'] ?? '', false); ?></div>
  <?php endif; ?>

  <div class="row">
    <div class="col-md-3">
      <div class="small-box bg-aqua">
        <div class="inner">
          <h3><?php echo e((int)($stats['slow_24h_count'] ?? 0), false); ?></h3>
          <p>Slow Queries (24h)</p>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="small-box bg-green">
        <div class="inner">
          <h3><?php echo e(number_format((float)($stats['slow_24h_avg_ms'] ?? 0), 1), false); ?> ms</h3>
          <p>Avg Slow Query Time</p>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="small-box bg-yellow">
        <div class="inner">
          <h3><?php echo e((int)($stats['slow_24h_max_ms'] ?? 0), false); ?> ms</h3>
          <p>Longest Slow Query</p>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="small-box bg-light-blue">
        <div class="inner">
          <h3><?php echo e(strtoupper($env['cache'] ?? 'file'), false); ?></h3>
          <p>Cache Driver</p>
        </div>
      </div>
    </div>
  </div>

  <div class="box box-primary">
    <div class="box-header with-border">
      <h3 class="box-title">Environment</h3>
      <div class="box-tools">
        <form method="POST" action="<?php echo e(route('performance.clean'), false); ?>" class="form-inline" style="display:inline;">
          <?php echo csrf_field(); ?>
          <label class="checkbox-inline"><input type="checkbox" name="purge_slow" value="1"> Purge slow logs older than</label>
          <input type="number" name="keep_days" min="0" value="7" class="form-control input-sm" style="width:80px;" />
          <button type="submit" class="btn btn-success btn-sm" style="background-color:#22c55e;border-color:#16a34a;color:#fff;">Clean Now</button>
        </form>
      </div>
    </div>
    <div class="box-body">
      <ul>
        <li>PHP: <?php echo e($env['php'] ?? '', false); ?></li>
        <li>Laravel: <?php echo e($env['laravel'] ?? '', false); ?></li>
        <li>Queue: <?php echo e(strtoupper($env['queue'] ?? ''), false); ?></li>
        <li>OPcache: <?php echo e(!empty($env['opcache_enabled']) ? 'Enabled' : 'Disabled', false); ?></li>
      </ul>
    </div>
  </div>

  <div class="box box-primary">
    <div class="box-header with-border">
      <h3 class="box-title">Top Slow Queries (24h)</h3>
    </div>
    <div class="box-body table-responsive">
      <table class="table table-striped">
        <thead>
          <tr>
            <th>Time (ms)</th>
            <th>SQL</th>
            <th>URL</th>
            <th>When</th>
          </tr>
        </thead>
        <tbody>
          <?php $__empty_1 = true; $__currentLoopData = $top; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
              <td><?php echo e((int)$row->time_ms, false); ?></td>
              <td><code style="white-space: pre-wrap;"><?php echo e(Str::limit($row->sql, 300), false); ?></code></td>
              <td class="small"><?php echo e($row->url, false); ?></td>
              <td class="small"><?php echo e(\Carbon::createFromTimestamp(strtotime($row->created_at))->format(session('business.date_format') . ' ' . 'h:i A'), false); ?></td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr><td colspan="4" class="text-center text-muted">No slow queries recorded in the last 24 hours.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <?php if(!empty($indexes)): ?>
  <div class="box box-primary">
    <div class="box-header with-border">
      <h3 class="box-title">Index Health</h3>
    </div>
    <div class="box-body table-responsive">
      <table class="table table-bordered">
        <thead>
          <tr>
            <th>Table</th>
            <th>Index</th>
            <th>Status</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $indexes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $table => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($table, false); ?></td>
                <td><?php echo e($idx['name'], false); ?></td>
                <td><?php echo $idx['present'] ? '<span class="label bg-green">Present</span>' : '<span class="label bg-red">Missing</span>'; ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>
  <?php endif; ?>

</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adminkim/public_html/resources/views/performance/index.blade.php ENDPATH**/ ?>